/* (c) Terasense Group, Inc., 2016

The simplest programm that read data from a TeraFAST device.

*/


#include "libterafast.h"

#include <stdlib.h>

int main(int argc, char* argv[])
{	
	TF_RES res = TF_OK;
	TF_DATA buf;
	
// Initialize the device

	res = tfInit();
	if (res != TF_OK) {
		printf("Device initialization failed, code %d", res);
		return res;
	}
	else 
		printf("Device initialized.\nReading %d pixels as %d lines by %d pixels.\n", dataLength, frameLength, frameSize);

//  Change length of the frame.
	tfSetFrameLength(10000);

//	Turn on the difference mode if needed.
//	tfSetDifference(1);

// Allocate memory for the data buffer. Notice that dataLength variable is not set prior initialization.
	buf = (TF_DATA) malloc(dataLength*sizeof(TF_ELEMENT));

// Start data aquisition
	res = tfStart();
// Read data
	if (tfRead(buf) != TF_OK) {
		printf("Error reading data, code %d\n", res);
	}
	else{
// Do something with the data.
		for (int y = 0; y < frameLength; y++){
			for (int x = 0; x < frameSize; x++){
				if(buf[x + y * frameSize]>100) {
				printf("%4d %4d %4d\n", x, y, buf[x + y*frameSize]);
				}
			}
			//printf("\n");
		}
	}
// Stop data aquisition.
	res = tfStop();

// Close the device.
	res = tfClose();

//Release memory
	free(buf);


	printf("Press ENTER to continue.");
	getchar();

	

	return res;

}

